﻿package {
	import flash.events.*;
	import flash.display.*;
	import flash.geom.Rectangle;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	
	public class CategoriesPanel extends MovieClip{
		public var gap_vert:Number = 10;
		public var startx = 0;
		public var starty = 0;
		public var dispatcher:EventDispatcher = new EventDispatcher();
		public var draggingCategory:Category = null;
		public var rectCategories:Rectangle = new Rectangle();
		public var flagPlacesChanged:Boolean = false;
		public var flagDragged = false;
		public var copyMoveCategoryId:String = "";
		public var lastOverCategory:Category;
		public var mc_mask:Sprite = new Sprite();
		
		//items on stage
		//mc_holder	- categories holder
		//mc_scrollbar
		//mc_back
		
		//constructor:
		public function CategoriesPanel(){
			makeMask();
			
			//position scrollbar
			mc_scrollbar.x = this.mc_back.x + this.mc_back.width - this.mc_scrollbar.width;
			mc_scrollbar.y = this.mc_holder.y;
			mc_scrollbar.setHeight(this.mc_holder.height);
			
			//scrollbar event
			this.mc_scrollbar.dispatcher.addEventListener("scrollBarMoving",scrollBarMovingHandler);
			
			//wheel event:
			this.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
			
			setContextMenu();
		}
		
		//---------------------------------------------------------------------
		//resets categories panel
		public function restart(){
			this.mc_holder.restart();
		}
		
		//---------------------------------------------------------------------
		// make mask. replicate the mask as the mc_holder
		private function makeMask(){
			this.addChild(this.mc_mask);
			
			//fill the mask
			this.mc_mask.graphics.beginFill(0xFF00FF);
			this.mc_mask.graphics.drawRect(0,0,this.mc_holder.width,this.mc_holder.height);			
			this.mc_mask.graphics.endFill();
			
			//position the mask on holder position
			this.mc_mask.x = this.mc_holder.x;
			this.mc_mask.y = this.mc_holder.y;
			
			this.mc_holder.mask = this.mc_mask;
		}				
		
		//--------------------------------------------------------
		// get categories array from the holder
		public function getArrCategories(){
			return(this.mc_holder.arrCategories);
		}
		
		//--------------------------------------------------------
		// get number of categories
		public function getNumCategories(){
			return(this.mc_holder.arrCategories.length);
		}
		
		//--------------------------------------------------------
		// trigger event of adding a new category to website.
		public function triggerAddNewCategoryEvent(){
			var website = this.parent;
			website.addNewCategoryRequest();
		}
		
		//--------------------------------------------------------
		// set context menu for website object
		public function setContextMenu(){
			var menu:ContextMenu = new ContextMenu();
			
			//add category
			var	itemAddCategory:ContextMenuItem = new ContextMenuItem("Add new category");
			itemAddCategory.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onAddCategory);
			
			menu.customItems.push(itemAddCategory);
			
			menu.hideBuiltInItems();
			this.contextMenu = menu;
		}
		
		//--------------------------------------------------------------------------------		
		//add category event. trigger event to parent.
		public function onAddCategory(event:ContextMenuEvent){
			triggerAddNewCategoryEvent();
		}
		
		//--------------------------------------------------------------------------------		
		//hide mouse over from last category (if right clicked, and over event didn't took place
		public function hideOverBorderFromLastCategory(){
			if(this.lastOverCategory == null) return(false);
			this.lastOverCategory.hideOverBorder();
		}
			
		//--------------------------------------------------------------------------------		
		//reduce number of items from some category
		public function reduceCategoryNumItems(categoryID,numToReduce:Number){
			this.mc_holder.reduceCategoryNumItems(categoryID,numToReduce);
		}
		
		//--------------------------------------------------------------------------------		
		// get category by id. if not found - return null
		public function getCategoryById(catID:String){
			return(this.mc_holder.getCategoryById(catID));
		}
		
		//--------------------------------------------------------------------------------		
		// set categories
		public function setCategories(xml:XMLList){
			mc_holder.setCategories(xml);
			updateScrollbar();
			return(false);
		}
		
		//--------------------------------------------------------------------------------		
		// add new category
		public function addNewCategory(xml:XMLList){
			this.mc_holder.addNewCategory(xml);
			updateScrollbar();
		}
						
		//--------------------------------------------------------------------------------		
		// removes category from the list by id
		public function removeCategory(categoryID){
			mc_holder.removeCategory(categoryID);
			updateScrollbar();
		}
								
		//--------------------------------------------------------------------------------		
		// get array of all catories order
		public function getOrderArray(){
			return(this.mc_holder.getOrderArray());
		}
		
		//--------------------------------------------------------------------------------		
		// get selected category id
		public function getSelectedCategoryID(){
			return(this.mc_holder.getSelectedCategoryID());
		}
		
		//--------------------------------------------------------------------------------				
		//get selected 
		public function getSelectedCategory(){
			return(this.mc_holder.getSelectedCategory());
		}
		
		//--------------------------------------------------------------------------------		
		// get last saved copy or move category id.
		public function getCopyMoveCategoryId(){
			return(this.mc_holder.getCopyMoveCategoryId());
		}
		
		//--------------------------------------------------------------------------------		
		//unselect all categories
		public function unselectAllCategories(){
			this.mc_holder.unselectAllCategories()
		}
		
		//--------------------------------------------------------------------------------		
		// check if item has been dragged to category. called by the parent when stop item drag.
		public function checkItemDragToCategory(){
			this.mc_holder.checkItemDragToCategory();
		}
		
		//--------------------------------------------------------------------------------		
		// start editing the name of selected categoory
		public function editNameSelectedCategory(){
			this.mc_holder.editNameSelectedCategory();
		}
				
		//--------------------------------------------------------------------------------		
		// delete the selected category
		public function deleteSelectedCategory(){
			this.mc_holder.deleteSelectedCategory();
		}
	
		//----------------------------------------------------------------------
		// update data of some category (by id)
		public function updateCategoryData(catID:String,catData:Object){
			this.mc_holder.updateCategoryData(catID,catData);
		}
		
		//----------------------------------------------------------------------
		// invoked whtn the scrollbar moving, scroll the pane.
		private function scrollBarMovingHandler(event:Event){
			movePaneByScrollbar();
		}		
				
		//----------------------------------------------------------------------
		// move pane by scrollbar
		public function movePaneByScrollbar(){
			var percent = mc_scrollbar.getPosPercent();
			if(mc_holder.height <= mc_mask.height) return(false);
			
			var holderMoveSpace = mc_holder.height - mc_back.height+12;
			var holderPart = Math.ceil(holderMoveSpace * percent);
			this.mc_holder.y = mc_mask.y - holderPart;
		}		
	
		//----------------------------------------------------------------------
		// invoked when the wheel moving. move the scroller one down.
		private function mouseWheelHandler(event:MouseEvent){			   
			var dir:String = "down";
			if(event.delta > 0) dir="up";
			this.mc_scrollbar.moveBar(40,dir);
			movePaneByScrollbar();
		}
		
		//----------------------------------------------------------------------
		//update scrollbar according the mc_holder diameters
		public function updateScrollbar(){
			mc_scrollbar.update(this.mc_holder.height,this.mc_holder.y,this.mc_mask.height,this.mc_mask.y);
		}
				
	}
}